﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;

public partial class Admin_Template_ClubTemplateList_Add : System.Web.UI.Page
{
    private 访问 访问;
    protected String 模板类型;
    protected void Page_Load(object sender, EventArgs e)
    {
        模板类型 = Request.QueryString["ttype"];
        访问 = new 访问(this.Context);
        访问.开始处理("增加" + 模板类型 + "模板", "网站后台", "增加" + 模板类型 + "模板", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            增加模板();
        else
            初始化();
    }

    private void 初始化()
    {
        DirectoryInfo[] DIS = new DirectoryInfo(Server.MapPath("~/Template/Club/")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
        {
            String 模板名称 = DIS[i].Name;
            MoBanZu.Items.Add(new ListItem(模板名称, 模板名称));
        }
    }

    private void 增加模板()
    {
        访问.验证权限("53");
        String 模板名称 = MoBanMingChen.Text;
        String 模板组 = MoBanZu.SelectedValue;
        bool 是否WAP = ShiFouWAP_T.Checked;
        String 模板说明 = MoBanShuoMing.Text;
        String 代码内容 = 常用.网页_获取默认内容(模板名称, 是否WAP);

        if (模板名称.Length < 1 || 模板名称.Length > 50)
            throw new Exception("模板名称的长度只能在1-50之间");
        if (模板说明.Length < 1 || 模板说明.Length > 100)
            throw new Exception("模板说明的长度只能在1-100之间");

        int ZGID = 常用.XML_最高ID(new DirectoryInfo(Server.MapPath("~/Template/Club/" + 模板组 + "/Club/")));

        String ASPX代码, CS代码;
        编译器 编译器 = new 编译器(this.Context, 访问.连接, "社区模板/" + 模板类型, 是否WAP);
        编译器.模板名称 = 模板组;
        编译器.开始执行代码 = 编译器.开始执行代码
            .Replace("$所在位置$", 模板类型)
            .Replace("$内容类型$", "其它")
            .Replace("$内容小类型$", 模板类型);
        编译器.文件名称 = "{$文件名称$}";
        CS代码 = 编译器.编译(代码内容, "{$文件夹$}/{$文件$}", out ASPX代码);

        设置 模板 = new 设置("");
        模板["ID"] = ZGID;
        模板["模板名称"] = 模板名称;
        模板["模板类型"] = 模板类型;
        模板["查询字段"] = 编译器.查询字段;
        模板["是否WAP"] = 是否WAP;
        模板["模板说明"] = 模板说明;
        模板["代码内容"] = 代码内容;
        模板["创建时间"] = DateTime.Now;

        File.WriteAllText(Server.MapPath("~/Template/Club/" + 模板组 + "/Club/" + ZGID + ".xml"),
            模板.生成XML(), Encoding.UTF8);

        File.WriteAllText(Server.MapPath("~/Template/Club/" + 模板组 + "/Club_Aspx/" + ZGID + ".aspx"),
            ASPX代码.Replace("{$文件夹$}", "Template_Club_" + 模板组 + "_Club_Aspx")
            .Replace("{$文件$}", ZGID.ToString())
            .Replace("{$ID$}", "0"),
            Encoding.UTF8);
        File.WriteAllText(Server.MapPath("~/Template/Club/" + 模板组 + "/Club_Aspx/" + ZGID + ".aspx.cs"),
            CS代码.Replace("{$文件夹$}", "Template_Club_" + 模板组 + "_Club_Aspx")
            .Replace("{$文件$}", ZGID.ToString())
            .Replace("{$ID$}", "0"),
            Encoding.UTF8);

        访问统计_管理记录 管理记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        管理记录.记录("增加" + 模板类型 + "模板", 访问.用户["昵称"].ToString());

        Response.Redirect("ClubTemplateList_EditSource.aspx?ttype=" + Server.UrlEncode(模板类型) + "&group=" + Server.UrlEncode(模板组) + "&ID=" + ZGID);
    }
}
